﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NLToCode.Evaluation {
    public class Result {
        public double Top1 { get; set; }
        public double Top3 { get; set; }
        public double Top5 { get; set; }
        public double TopK { get; set; }

        public Result(List<int> ranks, int k, int n) {
            Top1 = ComputeTopKAccuracy(ranks, 1, n);
            Top3 = ComputeTopKAccuracy(ranks, 3, n);
            Top5 = ComputeTopKAccuracy(ranks, 5, n);
            TopK = ComputeTopKAccuracy(ranks, k, n);
        }

        public static double ComputeTopKAccuracy(List<int> ranks, int k, int n) {
            int topK = ranks.Where(s => s <= k).ToList().Count();
            double accuracy = (double) topK / n;
            return accuracy;
        }
    }
}
